/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.utility.SFXAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.FrailPower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class Healer
extends AbstractMonster {
    public static final String ID = "Healer";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("Healer");
    public static final String NAME = Healer.monsterStrings.NAME;
    public static final String[] MOVES = Healer.monsterStrings.MOVES;
    public static final String[] DIALOG = Healer.monsterStrings.DIALOG;
    private static final float IDLE_TIMESCALE = 0.8f;
    public static final String ENC_NAME = "HealerTank";
    private static final int HP_MIN = 48;
    private static final int HP_MAX = 56;
    private int MAGIC_ATTACK = 8;
    private int HEAL_AMT = 16;
    private int STR_AMOUNT = 2;
    private static final byte ATTACK = 1;
    private static final byte HEAL = 2;
    private static final byte BUFF = 3;

    public Healer(float x, float y) {
        super(NAME, ID, AbstractDungeon.monsterHpRng.random(48, 56), 0.0f, -20.0f, 230.0f, 250.0f, null, x, y);
        this.damage.add(new DamageInfo(this, this.MAGIC_ATTACK));
        this.loadAnimation("images/monsters/theCity/healer2/skeleton.atlas", "images/monsters/theCity/healer2/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "Idle", true);
        this.stateData.setMix("Hit", "Idle", 0.2f);
        e.setTime(e.getEndTime() * MathUtils.random());
        this.state.setTimeScale(0.8f);
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                this.playSfx();
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_DIAGONAL));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new FrailPower(AbstractDungeon.player, 2, true), 2));
                break;
            }
            case 2: {
                this.playSfx();
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "STAFF_RAISE"));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.25f));
                for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                    if (m.isDying || m.isEscaping) continue;
                    AbstractDungeon.actionManager.addToBottom(new HealAction(m, this, this.HEAL_AMT));
                }
                break;
            }
            case 3: {
                this.playSfx();
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "STAFF_RAISE"));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.25f));
                for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                    if (m.isDying || m.isEscaping) continue;
                    AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, this, new StrengthPower(m, this.STR_AMOUNT), this.STR_AMOUNT));
                }
                break;
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    private void playSfx() {
        if (MathUtils.randomBoolean()) {
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_HEALER_1A"));
        } else {
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_HEALER_1B"));
        }
    }

    private void playDeathSfx() {
        int roll = MathUtils.random(2);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_HEALER_2A");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_HEALER_2B");
        } else {
            CardCrawlGame.sound.play("VO_HEALER_2C");
        }
    }

    @Override
    public void changeState(String key) {
        switch (key) {
            case "STAFF_RAISE": {
                this.state.setAnimation(0, "Attack", false);
                this.state.setTimeScale(0.8f);
                this.state.addAnimation(0, "Idle", true, 0.0f);
                break;
            }
        }
    }

    @Override
    protected void getMove(int num) {
        int needToHeal = 0;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (m.isDying || m.isEscaping) continue;
            needToHeal += m.maxHealth - m.currentHealth;
        }
        if (needToHeal > 15 && !this.lastTwoMoves((byte)2)) {
            this.setMove((byte)2, AbstractMonster.Intent.BUFF);
            return;
        }
        if (num >= 40 && !this.lastTwoMoves((byte)1)) {
            this.setMove((byte)1, AbstractMonster.Intent.ATTACK_DEBUFF, this.MAGIC_ATTACK);
            return;
        }
        if (!this.lastTwoMoves((byte)3)) {
            this.setMove((byte)3, AbstractMonster.Intent.BUFF);
            return;
        }
        this.setMove((byte)1, AbstractMonster.Intent.ATTACK_DEBUFF, this.MAGIC_ATTACK);
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (info.output > 0) {
            this.state.setAnimation(0, "Hit", false);
            this.state.setTimeScale(0.8f);
            this.state.addAnimation(0, "Idle", true, 0.0f);
        }
    }

    @Override
    public void die() {
        this.playDeathSfx();
        this.state.setTimeScale(0.1f);
        this.useShakeAnimation(5.0f);
        super.die();
    }
}

